﻿//////////////////////////////////////////////
// RenderQueueWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkGraphicsWrap
{
	class DLL_ASTRAEUS_EXPORT RenderQueueWrapper final
	{
		public :

			// Environment update
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks
			// Functions
			static nkScripts::OutputValue addEntity (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue eraseEntity (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue clearQueue (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getEntityCount (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getEntity (const nkScripts::DataStack& stack) ;
	} ;
}